// <![CDATA[

var scrollDiv;
var hDiv;
var tClip;
var bClip;
var wClip;
var interval;
var topPos = 0;



function initScroller(id) {
    scrollDiv = document.getElementById(id);   
    var margin = parseInt(scrollDiv.offsetTop);
    
    var scrollDiv__controls = document.getElementById(id + '__controls');

    /* Style per il div interno (testo) */
    scrollDiv.style.width    = (scrollDiv.parentNode.offsetWidth - (margin * 2)) - 24 + 'px';
    scrollDiv.style.height   = 'auto';
    scrollDiv.style.overflow = 'hidden';
    
    /* Style per il div esterno (contenitore) */
    scrollDiv.parentNode.style.overflow = 'hidden';
    
    /* Style per il div con i controlli (testo) */
    scrollDiv__controls.style.display = 'block';  


    /* Impostazioni per visualizzare la parte di testo superiore */
    hDiv  = scrollDiv.offsetHeight;

    tClip = 0;   
    wClip = scrollDiv.parentNode.offsetWidth - (margin * 2);
    bClip = scrollDiv.parentNode.offsetHeight - (margin * 2);

    scrollDiv.style.clip = 'rect('+ tClip +'px,'+ wClip +'px,'+ bClip +'px,0)';   
    // alert("tClip:"+tClip+"\nwClip:"+wClip+"\nbClip:"+bClip+"\n");
}

function scroll(scrollBy, time) {
    tClip += scrollBy;
    bClip += scrollBy;
    topPos -= scrollBy;

    
    if (tClip < 0 || bClip > hDiv) {
        tClip -= scrollBy;
        bClip -= scrollBy;
        topPos += scrollBy;    
    }
    
    
    scrollDiv.style.clip = 'rect('+ tClip +'px, '+ wClip +'px, '+ bClip +'px, 0)';   
    scrollDiv.style.top = topPos + 'px';    
    interval = setTimeout('scroll('+ scrollBy +', '+ time +')', time);
}

function stopScroll() {
    if (interval) clearTimeout(interval);
}

// ]]>